<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;

class UserController extends Controller
{
    /**
     * Display a listing of users with search functionality
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // Get the search query if provided
        $search = $request->input('search');
        $role = $request->input('role');
        
        // Start with a base query
        $query = User::query();
        
        // Apply search filter if search query exists
        if ($search) {
            $query->where(function($q) use ($search) {
                $q->where('name', 'like', '%' . $search . '%')
                  ->orWhere('steamid', 'like', '%' . $search . '%')
                  ->orWhere('slug', 'like', '%' . $search . '%');
            });
        }
        
        // Apply role filter if role is provided
        if ($role) {
            $query->role($role);
        }
        
        // Get users with pagination
        $users = $query->orderBy('created_at', 'desc')
                      ->paginate(10)
                      ->withQueryString();
        
        // Get all roles for the filter dropdown
        $roles = Role::all()->pluck('name');
        
        return view('users.index', compact('users', 'search', 'role', 'roles'));
    }
}